<?php

/**
 * Class that operate on table 'operatingexpenses'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2012-07-26 17:38
 */
class OperatingexpensesMySqlDAO implements OperatingexpensesDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return OperatingexpensesMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM operatingexpenses WHERE operatingexpensesid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM operatingexpenses';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM operatingexpenses ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param operatingexpense primary key
     */
    public function delete($operatingexpensesid) {
        $sql = 'DELETE FROM operatingexpenses WHERE operatingexpensesid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($operatingexpensesid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param OperatingexpensesMySql operatingexpense
     */
    public function insert($operatingexpense) {
        $sql = 'INSERT INTO operatingexpenses (operatingexpensesname, operatingexpensestype, operatingexpensesvalue, tempdelete, currentdate) VALUES (?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($operatingexpense->operatingexpensesname);
        $sqlQuery->setNumber($operatingexpense->operatingexpensestype);
        $sqlQuery->set($operatingexpense->operatingexpensesvalue);
        $sqlQuery->setNumber($operatingexpense->tempdelete);
        $sqlQuery->set($operatingexpense->currentdate);

        $id = $this->executeInsert($sqlQuery);
        $operatingexpense->operatingexpensesid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param OperatingexpensesMySql operatingexpense
     */
    public function update($operatingexpense) {
        $sql = 'UPDATE operatingexpenses SET operatingexpensesname = ?, operatingexpensestype = ?, operatingexpensesvalue = ?, tempdelete = ?, currentdate = ? WHERE operatingexpensesid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($operatingexpense->operatingexpensesname);
        $sqlQuery->setNumber($operatingexpense->operatingexpensestype);
        $sqlQuery->set($operatingexpense->operatingexpensesvalue);
        $sqlQuery->setNumber($operatingexpense->tempdelete);
        $sqlQuery->set($operatingexpense->currentdate);

        $sqlQuery->setNumber($operatingexpense->operatingexpensesid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM operatingexpenses';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByOperatingexpensesname($value) {
        $sql = 'SELECT * FROM operatingexpenses WHERE operatingexpensesname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByOperatingexpensestype($value) {
        $sql = 'SELECT * FROM operatingexpenses WHERE operatingexpensestype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByOperatingexpensesvalue($value) {
        $sql = 'SELECT * FROM operatingexpenses WHERE operatingexpensesvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTempdelete($value) {
        $sql = 'SELECT * FROM operatingexpenses WHERE tempdelete = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCurrentdate($value) {
        $sql = 'SELECT * FROM operatingexpenses WHERE currentdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByOperatingexpensesname($value) {
        $sql = 'DELETE FROM operatingexpenses WHERE operatingexpensesname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByOperatingexpensestype($value) {
        $sql = 'DELETE FROM operatingexpenses WHERE operatingexpensestype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByOperatingexpensesvalue($value) {
        $sql = 'DELETE FROM operatingexpenses WHERE operatingexpensesvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTempdelete($value) {
        $sql = 'DELETE FROM operatingexpenses WHERE tempdelete = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCurrentdate($value) {
        $sql = 'DELETE FROM operatingexpenses WHERE currentdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return OperatingexpensesMySql
     */
    protected function readRow($row) {
        $operatingexpense = new Operatingexpense();

        $operatingexpense->operatingexpensesid = isset($row['operatingexpensesid']) ? $row['operatingexpensesid'] : '';
        $operatingexpense->operatingexpensesname = isset($row['operatingexpensesname']) ? $row['operatingexpensesname'] : '';
        $operatingexpense->operatingexpensestype = isset($row['operatingexpensestype']) ? $row['operatingexpensestype'] : '';
        $operatingexpense->operatingexpensesvalue = isset($row['operatingexpensesvalue']) ? $row['operatingexpensesvalue'] : '';
        $operatingexpense->tempdelete = isset($row['tempdelete']) ? $row['tempdelete'] : '';
        $operatingexpense->currentdate = isset($row['currentdate']) ? $row['currentdate'] : '';

        return $operatingexpense;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return OperatingexpensesMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>